\version "2.24.0"
\language "deutsch"

\paper {
  system-system-spacing = #'((basic-distance . 20))
  markup-system-spacing = #'((basic-distance . 23))
  left-margin = 1.5\cm
  line-width = 18.7\cm
  print-page-number = false
  top-margin = 10\mm
  bottom-margin = 5\mm
  %ragged-last-bottom=##f
}

% diacritice: ă â î ş ţ Ţ Ş Ă Î

\header {
  title = "La mulți ani"
  subtitle = " "
  %poet = "Vasile Militaru (1885 - 1959)"
  %composer = \markup \center-column { "Călin Buzilă" \small "19 august 2013" }
  %arranger = "io"
  %meter = "Moderato"
  tagline=""
}

global = {
  \key g \major
  %\partial 2
  \time 6/8
  \set Staff.midiInstrument = "clarinet"
}

womenWordsOne = \lyricmode {
  \set stanza = "1."
  La mulți ani cu să -- nă -- ta -- te,
  să vă dea Dom -- nul tot ce do -- riți,
  zi -- le se -- ni -- ne și fe -- ri -- ci -- re,
  La __ mulți ani să tră -- iți!
  Mulți ani, __ La mulți ani __
  La mulți ani fe -- ri -- ciți să tră -- iți, __
  Mulți ani, __ La mulți ani __
  La mulți ani fe -- ri -- ciți să tră -- iți! __
}

womenWordsTwo = \lyricmode {
  \set stanza = "2."
  "Vă fi" -- e via -- ța nu-mai lu -- mi -- nă,
  ca în lu -- mi -- nă să dăi -- nu -- iți,
  pen -- tru cre -- din -- ță și mân -- tu -- i -- re,
  La __ mulți ani să tră -- iți!
}

menWords = \lyricmode {
  \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 
  \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 
  \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 
  \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 
  \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 
  \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 
  \skip 1 \skip 1 \skip 1 
  La mulți ani, La mulți ani,
  La mulți ani fe -- ri -- ciți să tră -- iți,
  La mulți ani!
  La mulți ani, La mulți ani,
  La mulți ani fe -- ri -- ciți să tră -- iți! __
}
  
sopMusic = \relative c' {
  d4 d8 g4 g8 a( g) a h4 h8
  a8 h c h4 h8 a g a h4.
  d8 d c h4 h8 a g a h4 h8
  a8( h) c h4. a4 a8 g4.
  \bar ":|." \break
  \partial 4.
  g4.^\markup "Fine" c4.( c4 h8 a4.)
  h4 c8 h4.( h4 a8 g4.)
  a4 h8 a4. a4 g8 fis4. g4 a8 h4.( h)  h4.\rest 
  g4. c4.( c4 h8 a4.)
  h4 c8 h4.( h4 a8 g4.)
  a4 h8 a4. a4 g8 fis4. g4 fis8 g4.( g)
  
  \bar "|."
}

altMusic = \relative c' {
  d4 d8 g4 g8 a( g) d g4 g8
  fis8 g a g4 g8 fis e fis g4.
  h8 h a g4 g8 fis e fis g4 g8
  fis8( g) a g4. fis4 fis8 g4.
  g4. a4.( a4 g8 fis 4.)
  %g4. fis4.( fis4 g8 a4.)
  g4 a8 g4.( g4 fis8 e4.)
  %g4 fis8 fis4.( fis4 fis8 g4.)
  fis4 g8 fis4. fis4 g8
  fis4. g4 fis8 g4.( g)
  h4.\rest
  g4. a4.( a4 g8 fis 4.)
  g4 a8 g4.( g4 fis8 e4.)
  fis4 g8 fis4. fis4 g8
  fis4. g4 fis8 g4.( g)
  
}

bassMusic = \relative c {
  d4 d8 g4 g8 d( d) d d4 d8
  %d4 d8 g4 g8 a( g) d g4 g8
  d8 d d g4 g8 d8 d d d4.
  g8 g a g4 g8 d8 d d d4 d8
  d8( d) d g4. d4 d8 <g g,>4.
  r4. r c4 h8 a4. r r
  h4 a8 g4. fis4 e8 d4. d4 d8 
  d4. d4 d8 g4. g4 g8 g4.
  r4. r c4 h8 a4. r r
  h4 a8 g4. fis4 e8 d4. d4 d8 
  d4. d4 d8 <g~ g,>4.( <g g,>)
  
}

myScore = \new Score <<
  \new ChoirStaff <<
    \new Staff <<
     \new Voice { \voiceOne \global \sopMusic }
     \addlyrics { \womenWordsOne }
     \addlyrics { \womenWordsTwo } 
     \new Voice { \voiceTwo \global \altMusic }
    >>
    \new Staff <<
     \clef bass
     \new Voice { \global \bassMusic }
     \addlyrics { \menWords }
    >>
    >>
>>

\score {
  \myScore
  \layout { }
}

midiOutput = \midi {
  \tempo 4 = 77
  \context { \Voice \remove "Dynamic_performer" }
}

\score {
  \unfoldRepeats
  \myScore
  \midi { \midiOutput }
}

\score {
  \unfoldRepeats
  \new Voice { \global \sopMusic }
  \midi { \midiOutput }
}

\score {
  \unfoldRepeats
  \new Voice { \global \altMusic }
  \midi { \midiOutput }
}

\score {
  \unfoldRepeats
  \new Voice { \global \bassMusic }
  \midi { \midiOutput }
}
